/*
 * Decompiled with CFR 0.152.
 */
package stanza.micro;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Gauge;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextField;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreFullException;
import javax.microedition.rms.RecordStoreNotFoundException;

public final class MicroStanza
extends MIDlet {
    private static final boolean D = Const.DEBUG;
    private BookCanvas canvas;
    BookList bookList;

    public final void startApp() {
        block11: {
            MicroStanza microStanza = this;
            if (microStanza.canvas == null) {
                try {
                    long l;
                    block10: {
                        Display.getDisplay((MIDlet)microStanza).setCurrent((Displayable)new SplashScreen(microStanza));
                        l = System.currentTimeMillis();
                        microStanza.bookList = new BookList(microStanza);
                        microStanza.canvas = new BookCanvas(microStanza);
                        try {
                            MicroStanza microStanza2 = microStanza;
                            RecordStore recordStore = null;
                            try {
                                recordStore = RecordStore.openRecordStore((String)"config", (boolean)true);
                                if (recordStore != null && recordStore.getNumRecords() > 0) {
                                    Object object = recordStore.getRecord(1);
                                    object = new ByteArrayInputStream((byte[])object);
                                    Object object2 = object = (Object)new DataInputStream((InputStream)object);
                                    Page.access$700(microStanza2.canvas.view, object2.readInt());
                                    int n = object2.readInt();
                                    int n2 = object2.readInt();
                                    int n3 = object2.readInt();
                                    BookList.access$800(microStanza2.bookList, object2.readInt());
                                    BookCanvas.setScrollDelay(object2.readInt());
                                    DeviceLighting deviceLighting = DeviceLighting.access$1000();
                                    DeviceLighting.access$1100(deviceLighting, false, object2.readInt());
                                    DeviceLighting.access$1100(deviceLighting, true, object2.readInt());
                                    Page.access$1300(microStanza2.canvas.view, object2.readBoolean());
                                    microStanza2.canvas.setFullscreen(object2.readBoolean());
                                    Page.access$1500(microStanza2.canvas.view, object2.readBoolean());
                                    microStanza2.canvas.displayStatus = object2.readBoolean();
                                    microStanza2.canvas.positionAsPerc = object2.readBoolean();
                                    Page.access$1800(microStanza2.canvas.view, object2.readBoolean());
                                    Page.access$1900(microStanza2.canvas.view, object2.readBoolean());
                                    microStanza2.canvas.view.setFont(Font.getFont((int)n, (int)n2, (int)n3));
                                    ((FilterInputStream)object).close();
                                }
                            }
                            finally {
                                if (recordStore != null) {
                                    recordStore.closeRecordStore();
                                }
                            }
                        }
                        catch (Exception exception) {
                            if (!D) break block10;
                            Log.access$3500(exception);
                        }
                    }
                    BookCanvas.access$300(microStanza.canvas, l);
                    return;
                }
                catch (Exception exception) {
                    if (!D) break block11;
                    Log.access$3500(exception);
                }
            }
        }
    }

    public final void pauseApp() {
    }

    public final void destroyApp(boolean unconditional2) {
        MicroStanza unconditional2;
        block10: {
            unconditional2 = this;
            BookList.access$500(unconditional2.bookList, BookCanvas.access$400(unconditional2.canvas));
            try {
                MicroStanza microStanza = unconditional2;
                RecordStore recordStore = null;
                try {
                    DataOutputStream dataOutputStream;
                    Object object = new ByteArrayOutputStream();
                    DataOutputStream dataOutputStream2 = dataOutputStream = new DataOutputStream((OutputStream)object);
                    dataOutputStream2.writeInt(microStanza.canvas.view.colorScheme);
                    Font font = microStanza.canvas.view.font;
                    dataOutputStream2.writeInt(font.getFace());
                    dataOutputStream2.writeInt(font.getStyle());
                    dataOutputStream2.writeInt(font.getSize());
                    dataOutputStream2.writeInt(microStanza.bookList.bookIdx);
                    dataOutputStream2.writeInt(BookCanvas.getScrollDelay());
                    dataOutputStream2.writeInt(DeviceLighting.access$2500(DeviceLighting.access$1000(), false));
                    dataOutputStream2.writeInt(DeviceLighting.access$2500(DeviceLighting.access$1000(), true));
                    dataOutputStream2.writeBoolean(microStanza.canvas.view.lineWrap);
                    dataOutputStream2.writeBoolean(microStanza.canvas.fullscreen);
                    dataOutputStream2.writeBoolean(microStanza.canvas.view.rotated);
                    dataOutputStream2.writeBoolean(microStanza.canvas.displayStatus);
                    dataOutputStream2.writeBoolean(microStanza.canvas.positionAsPerc);
                    dataOutputStream2.writeBoolean(microStanza.canvas.view.hyphenate);
                    dataOutputStream2.writeBoolean(microStanza.canvas.view.justify);
                    dataOutputStream.flush();
                    object = ((ByteArrayOutputStream)object).toByteArray();
                    recordStore = RecordStore.openRecordStore((String)"config", (boolean)true);
                    if (recordStore.getNumRecords() == 0) {
                        recordStore.addRecord((byte[])object, 0, ((Object)object).length);
                    } else {
                        recordStore.setRecord(1, (byte[])object, 0, ((Object)object).length);
                    }
                    dataOutputStream.close();
                }
                catch (Exception exception) {
                    throw exception;
                }
                finally {
                    if (recordStore != null) {
                        recordStore.closeRecordStore();
                    }
                }
            }
            catch (Exception exception) {
                if (!D) break block10;
                Log.access$3500(exception);
            }
        }
        unconditional2.notifyDestroyed();
    }

    private static final class Page {
        private static final boolean D = Const.DEBUG;
        private int width;
        private int height;
        private int widthOrig;
        private int heightOrig;
        private int background;
        private int foreground;
        private Font font;
        private StringBuffer buffer;
        private int borderSpace;
        private boolean lineWrap;
        private boolean hyphenate;
        private boolean justify;
        private boolean rotated;
        private Book book;
        private int position;
        private int scrollWidth;
        private int scrollHeight;
        private int[] charWidths;
        private Image offscreen;
        private Image origscreen;
        private int colorScheme = 0;
        private Screen screen;

        private Page(int width, int height) throws Exception {
            this.setDimension(width, height);
            this.buffer = new StringBuffer(256);
            this.borderSpace = 2;
            this.lineWrap = true;
            this.scrollWidth = 5;
            this.scrollHeight = 5;
            this.charWidths = new int[256];
            this.hyphenate = true;
            this.justify = true;
            this.setColors(0xFFFFFF, 0);
            this.setFont(Font.getFont((int)64, (int)0, (int)16));
        }

        private void setDimension(int width, int height) {
            this.widthOrig = width;
            this.heightOrig = height;
            this.scaleScreen();
        }

        private void scaleScreen() {
            if (this.rotated) {
                this.width = this.heightOrig;
                this.height = this.widthOrig;
                this.origscreen = Image.createImage((int)this.widthOrig, (int)this.heightOrig);
            } else {
                this.width = this.widthOrig;
                this.height = this.heightOrig;
            }
            this.offscreen = Image.createImage((int)this.width, (int)this.height);
        }

        private void setFont(Font font) throws Exception {
            this.font = font;
            this.resetPage();
        }

        private void resetPage() {
            int tmpLines = (this.height - 2 * this.borderSpace) / this.font.getHeight();
            this.screen = new Screen(tmpLines);
            for (int i = 0; i < this.charWidths.length; ++i) {
                this.charWidths[i] = this.font.charWidth((char)i);
            }
            if (this.book != null) {
                this.fillPage();
            }
        }

        private void setColors(int bG, int fG) {
            this.background = bG;
            this.foreground = fG;
        }

        private void setPosition(int pos) {
            if (pos > this.book.size) {
                pos = this.book.size - 1;
            }
            if (pos < 0) {
                pos = 0;
            }
            this.position = pos;
            this.book.setPosition(pos);
            this.fillPage();
        }

        private synchronized boolean nextLine() throws Exception {
            Object var1_1 = null;
            boolean bl = false;
            this.book.setPosition(this.screen.getPosition(this.screen.size()));
            String tmpLine2 = this.getLine(true);
            boolean tmpResult = tmpLine2 != null;
            if (tmpResult) {
                int tmpLine2 = this.book.getPosition();
                this.screen.cycleForward(tmpLine2, tmpLine2);
                this.position = this.screen.getPosition(0);
            }
            return tmpResult;
        }

        private synchronized void lastLine() throws Exception {
            boolean bl = false;
            Object var1_2 = null;
            this.book.setPosition(this.screen.getPosition(0) - 1);
            String line2 = this.getLine(false);
            if (line2 != null) {
                int line2 = this.book.getPosition() + 1;
                this.screen.cycleBackward(line2, line2);
                this.position = this.screen.getPosition(0);
            }
        }

        private void fillPage() {
            this.book.setPosition(this.position);
            int n = this.position;
            this.screen.setPosition(0, n);
            try {
                int n2 = this.screen.size();
                for (int i = 0; i < n2; ++i) {
                    String string = this.getLine(true);
                    this.screen.setPage(i, string);
                    n = this.book.getPosition();
                    this.screen.setPosition(i + 1, n);
                }
                return;
            }
            catch (Exception e) {
                if (D) {
                    Log.access$3500(e);
                }
                throw new RuntimeException(e.getMessage());
            }
        }

        private String getLine(boolean next) throws Exception {
            if (next && this.book.getPosition() >= this.book.size - 1) {
                return null;
            }
            if (!next && this.book.getPosition() <= 0) {
                return null;
            }
            boolean len = false;
            int ws = -1;
            int hy = -1;
            int index = 0;
            boolean eof = false;
            this.buffer.setLength(0);
            while (true) {
                char c;
                try {
                    c = Book.access$8900(this.book, next ? 1 : -1);
                }
                catch (EOFException eOFException) {
                    eof = true;
                    break;
                }
                if (c == '\t') {
                    c = ' ';
                }
                if (c == 13) continue;
                if (c == '\n') {
                    this.buffer.append('\n');
                    break;
                }
                if (c == '\u00ad') {
                    if (this.hyphenate) {
                        if (!next) continue;
                        hy = index;
                    }
                    c = '\u0000';
                }
                if (c == ' ') {
                    ws = index;
                }
                char c2 = c;
                Page e = this;
                if ((e += c2 < '\u0100' ? e.charWidths[c2] : e.font.charWidth(c2)) >= this.width - 2 * this.borderSpace - this.scrollWidth) {
                    Book.access$8900(this.book, next ? -1 : 1);
                    if (ws == -1 && hy == -1 || !this.lineWrap) break;
                    int loc = ws > hy ? ws : hy;
                    ws = index - loc - 1;
                    Book.access$8900(this.book, ws * (next ? -1 : 1));
                    index = loc;
                    this.buffer.setLength(index);
                    if (hy != loc) break;
                    this.buffer.append('-');
                    break;
                }
                this.buffer.append(c);
                ++index;
            }
            if (eof && index == 0) {
                return null;
            }
            if (this.book.rightToLeft == next) {
                this.buffer.reverse();
            }
            return this.buffer.toString();
        }

        public final void draw(Graphics graphic, int x2, int y2) {
            int n;
            int n2;
            int n3;
            int n4;
            Graphics x2 = graphic;
            graphic = this;
            Graphics y2 = graphic.offscreen.getGraphics();
            y2.setColor(graphic.background);
            y2.fillRect(0, 0, graphic.width, graphic.height);
            y2.setColor(graphic.foreground);
            y2.setFont(graphic.font);
            int n5 = 0;
            if (graphic.book.rightToLeft) {
                n4 = 24;
                n3 = graphic.width - graphic.scrollWidth - graphic.borderSpace;
            } else {
                n4 = 20;
                n3 = graphic.borderSpace;
            }
            int n6 = graphic.width - 2 * graphic.borderSpace - graphic.scrollWidth;
            Vector<String> vector = new Vector<String>();
            StringBuffer stringBuffer = new StringBuffer();
            Object var11_13 = null;
            int n7 = graphic.screen.size();
            for (n2 = 0; n2 < n7; ++n2) {
                n = n2;
                String string = null;
                string = graphic.screen.getPage(n);
                if (string != null) {
                    char[] cArray = string.toCharArray();
                    if (!graphic.justify || cArray.length > 0 && (cArray[cArray.length - 1] == '\n' || cArray[0] == '\n')) {
                        y2.drawString(string, n3, graphic.borderSpace + n5, n4);
                    } else {
                        int n8;
                        vector.removeAllElements();
                        stringBuffer.setLength(0);
                        int n9 = 0;
                        int n10 = cArray.length;
                        for (n8 = 0; n8 < n10; ++n8) {
                            if (n9 != 0 && cArray[n8] == ' ') {
                                vector.addElement(stringBuffer.toString());
                                stringBuffer.setLength(0);
                                continue;
                            }
                            stringBuffer.append(cArray[n8]);
                            if (n9 != 0 || cArray[n8] == ' ') continue;
                            n9 = 1;
                        }
                        if (stringBuffer.length() > 0) {
                            vector.addElement(stringBuffer.toString());
                        }
                        n8 = 0;
                        n9 = vector.size();
                        for (n10 = 0; n10 < n9; ++n10) {
                            n8 += graphic.font.stringWidth((String)vector.elementAt(n10));
                        }
                        n10 = n3;
                        int n11 = vector.size();
                        for (n9 = 0; n9 < n11; ++n9) {
                            String string2 = (String)vector.elementAt(n9);
                            if (n9 == n11 - 1) {
                                y2.drawString(string2, n6 - graphic.font.stringWidth(string2), graphic.borderSpace + n5, n4);
                                continue;
                            }
                            y2.drawString(string2, n10, graphic.borderSpace + n5, n4);
                            int n12 = graphic.font.stringWidth(string2);
                            int n13 = n6 - (n10 += n12);
                            n8 -= n12;
                            n12 = n11 - n9 - 1;
                            n12 = (n13 - n8) / n12;
                            n10 += n12;
                        }
                    }
                }
                n5 += graphic.font.getHeight();
            }
            y2.setColor(graphic.foreground);
            y2.drawRect(0, 0, graphic.width - 1, graphic.height - 1);
            y2.setColor(graphic.background);
            y2.fillRect(graphic.width - graphic.scrollWidth, 0, graphic.scrollWidth - 1, graphic.height - 1);
            y2.setColor(graphic.foreground);
            y2.drawRect(graphic.width - graphic.scrollWidth, 0, graphic.scrollWidth - 1, graphic.height - 1);
            n2 = (graphic.height - graphic.scrollHeight) * graphic.book.getPosition() / graphic.book.size;
            y2.fillRect(graphic.width - graphic.scrollWidth, n2, graphic.scrollWidth - 1, graphic.scrollHeight - 1);
            if (graphic.rotated) {
                Graphics graphics = graphic.origscreen.getGraphics();
                for (int i = 0; i < graphic.widthOrig; ++i) {
                    for (n = 0; n < graphic.heightOrig; ++n) {
                        graphics.setClip(i, n, 1, 1);
                        graphics.drawImage(graphic.offscreen, i - n, n + i - graphic.widthOrig, 20);
                    }
                }
            } else {
                graphic.origscreen = graphic.offscreen;
            }
            x2.drawImage(graphic.origscreen, 0, 0, 20);
        }

        static /* synthetic */ void access$700(Page x0, int x1) {
            v0.colorScheme = x1;
            switch (x0.colorScheme) {
                case 1: {
                    x0.setColors(0xFFFFFF, 255);
                    return;
                }
                case 2: {
                    x0.setColors(0, 65280);
                    return;
                }
                case 3: {
                    x0.setColors(160, 0xFFFFFF);
                    return;
                }
            }
            x0.setColors(0xFFFFFF, 0);
        }

        static /* synthetic */ void access$1300(Page x0, boolean x1) {
            v0.lineWrap = x1;
            if (x0.book != null) {
                x0.fillPage();
            }
        }

        static /* synthetic */ void access$1500(Page x0, boolean x1) {
            v0.rotated = x1;
            x0.scaleScreen();
        }

        static /* synthetic */ void access$1800(Page x0, boolean x1) {
            v0.hyphenate = x1;
            if (x0.book != null) {
                x0.fillPage();
            }
        }

        static /* synthetic */ void access$1900(Page x0, boolean x1) {
            v0.justify = x1;
            if (x0.book != null) {
                x0.fillPage();
            }
        }

        static /* synthetic */ Book access$4700(Page x0) {
            return x0.book;
        }

        static /* synthetic */ int access$4900(Page x0) {
            if (x0.book.size < 2) {
                return 0;
            }
            return x0.position * 100 / (x0.book.size - 1);
        }

        static /* synthetic */ int access$5000(Page x0) {
            if (x0.screen == null) {
                return 0;
            }
            return x0.screen.getPosition(0);
        }

        static /* synthetic */ void access$5500(Page x0, int x1) {
            Page page = x0;
            page.setPosition((page.book.size - 1) * x1 / 100);
        }

        static /* synthetic */ void access$5600(Page x0, int x1) {
            x0.setPosition(x1);
        }

        static /* synthetic */ void access$6000(Page x0, Book x1) {
            v0.book = x1;
            x0.setPosition(x1.getPosition());
        }

        static /* synthetic */ void access$6300(Page x0) throws Exception {
            x0.position = x0.screen.getPosition(x0.screen.size());
            x0.fillPage();
        }

        static /* synthetic */ void access$6500(Page x0) throws Exception {
            Object var2_2 = null;
            int n = x0.screen.size();
            for (int i = 0; i < n; ++i) {
                x0.lastLine();
            }
        }

        private static final class Screen {
            private final int[] positions;
            private final String[] content;

            private Screen(int lines) {
                this.positions = new int[lines + 1];
                this.content = new String[lines];
            }

            final synchronized int size() {
                return this.content.length;
            }

            final synchronized int getPosition(int line) {
                return this.positions[line];
            }

            final synchronized void setPosition(int line, int pos) {
                this.positions[line] = pos;
            }

            final synchronized String getPage(int line) {
                return this.content[line];
            }

            final synchronized void setPage(int line, String str) {
                this.content[line] = str;
            }

            final synchronized void cycleForward(String line, int newPosition) {
                for (int i = 0; i < this.content.length - 1; ++i) {
                    this.content[i] = this.content[i + 1];
                    this.positions[i] = this.positions[i + 1];
                }
                this.positions[this.content.length - 1] = this.positions[this.content.length];
                this.content[this.content.length - 1] = line;
                this.positions[this.positions.length - 1] = newPosition;
            }

            final synchronized void cycleBackward(String line, int newPosition) {
                this.positions[this.content.length] = this.positions[this.content.length - 1];
                for (int i = this.content.length - 1; i > 0; --i) {
                    this.content[i] = this.content[i - 1];
                    this.positions[i] = this.positions[i - 1];
                }
                this.content[0] = line;
                this.positions[0] = newPosition;
            }
        }
    }

    private static final class RTLText {
        private static final boolean D = Const.DEBUG;
        private static final Hashtable charsMap = new Hashtable<String, Shape>();

        private RTLText() {
        }

        private static String toHexString(String s) {
            StringBuffer tmpResult = new StringBuffer();
            for (int i = 0; i < s.length(); ++i) {
                tmpResult.append(RTLText.toHexString(s.charAt(i)));
            }
            return tmpResult.toString();
        }

        private static String toHexString(char data) {
            StringBuffer tmpResult = new StringBuffer("\\u");
            String hex = Integer.toHexString(data);
            switch (hex.length()) {
                case 1: {
                    tmpResult.append('0');
                }
                case 2: {
                    tmpResult.append('0');
                }
                case 3: {
                    tmpResult.append('0');
                }
                case 4: {
                    tmpResult.append(hex);
                    break;
                }
                default: {
                    throw new RuntimeException(hex + " not a valid character");
                }
            }
            return tmpResult.toString();
        }

        static /* synthetic */ String access$4000(String x0) {
            StringBuffer stringBuffer = new StringBuffer(0);
            Shape shape = null;
            for (int i = 0; i < x0.length(); ++i) {
                char c;
                block16: {
                    char c2;
                    char c3;
                    block18: {
                        block17: {
                            c = x0.charAt(i);
                            if (!charsMap.containsKey(String.valueOf(c))) break block16;
                            c3 = '\u0000';
                            c2 = '\u0000';
                            if (i == 0 || !charsMap.containsKey(String.valueOf(c3 = x0.charAt(i - 1)))) break block17;
                            shape = (Shape)charsMap.get(String.valueOf(c3));
                            if (shape.mInitial != '\u0000' || shape.mMedial != '\u0000') break block18;
                        }
                        c3 = '\u0000';
                    }
                    if (i == x0.length() - 1 || !charsMap.containsKey(String.valueOf(c2 = x0.charAt(i + 1))) || ((Shape)RTLText.charsMap.get((Object)String.valueOf((char)c2))).mMedial == '\u0000' && ((Shape)RTLText.charsMap.get((Object)String.valueOf((char)c2))).mFinal == '\u0000' && c2 != '\u0640') {
                        c2 = '\u0000';
                    }
                    if (c == '\u0644' && c2 != '\u0000' && (c2 == '\u0622' || c2 == '\u0623' || c2 == '\u0625' || c2 == '\u0627')) {
                        String string = String.valueOf(c) + String.valueOf(c2);
                        shape = (Shape)charsMap.get(string);
                        if (shape == null) {
                            if (D && D) {
                                Log.debug("null shape: " + RTLText.toHexString(string));
                            }
                        } else if (c3 != '\u0000') {
                            stringBuffer.append(shape.mFinal);
                        } else {
                            stringBuffer.append(shape.mIsolated);
                        }
                        ++i;
                        continue;
                    }
                    shape = (Shape)charsMap.get(String.valueOf(c));
                    if (shape == null) {
                        if (!D || !D) continue;
                        Log.debug("null shape: " + RTLText.toHexString(c));
                        continue;
                    }
                    if (c3 != '\u0000' && c2 != '\u0000' && shape.mMedial != '\u0000') {
                        stringBuffer.append(shape.mMedial);
                        continue;
                    }
                    if (c3 != '\u0000' && shape.mFinal != '\u0000') {
                        stringBuffer.append(shape.mFinal);
                        continue;
                    }
                    if (c2 != '\u0000' && shape.mInitial != '\u0000') {
                        stringBuffer.append(shape.mInitial);
                        continue;
                    }
                    stringBuffer.append(shape.mIsolated);
                    continue;
                }
                stringBuffer.append(c);
            }
            return stringBuffer.reverse().toString();
        }

        static {
            charsMap.put("\u0621", new Shape('\ufe80', '\u0000', '\u0000', '\u0000'));
            charsMap.put("\u0622", new Shape('\ufe81', '\u0000', '\u0000', '\ufe82'));
            charsMap.put("\u0623", new Shape('\ufe83', '\u0000', '\u0000', '\ufe84'));
            charsMap.put("\u0624", new Shape('\ufe85', '\u0000', '\u0000', '\ufe86'));
            charsMap.put("\u0625", new Shape('\ufe87', '\u0000', '\u0000', '\ufe88'));
            charsMap.put("\u0626", new Shape('\ufe89', '\ufe8b', '\ufe8c', '\ufe8a'));
            charsMap.put("\u0627", new Shape('\ufe8d', '\u0000', '\u0000', '\ufe8e'));
            charsMap.put("\u0628", new Shape('\ufe8f', '\ufe91', '\ufe92', '\ufe90'));
            charsMap.put("\u0629", new Shape('\ufe93', '\u0000', '\u0000', '\ufe94'));
            charsMap.put("\u062a", new Shape('\ufe95', '\ufe97', '\ufe98', '\ufe86'));
            charsMap.put("\u062b", new Shape('\ufe99', '\ufe9b', '\ufe9c', '\ufe9a'));
            charsMap.put("\u062c", new Shape('\ufe9d', '\ufe9f', '\ufea0', '\ufe9e'));
            charsMap.put("\u062d", new Shape('\ufea1', '\ufea3', '\ufea4', '\ufea2'));
            charsMap.put("\u062e", new Shape('\ufea5', '\ufea7', '\ufea8', '\ufea6'));
            charsMap.put("\u062f", new Shape('\ufea9', '\u0000', '\u0000', '\ufeaa'));
            charsMap.put("\u0630", new Shape('\ufeab', '\u0000', '\u0000', '\ufeac'));
            charsMap.put("\u0631", new Shape('\ufead', '\u0000', '\u0000', '\ufeae'));
            charsMap.put("\u0632", new Shape('\ufeaf', '\u0000', '\u0000', '\ufeb0'));
            charsMap.put("\u0633", new Shape('\ufeb1', '\ufeb3', '\ufeb4', '\ufeb2'));
            charsMap.put("\u0634", new Shape('\ufeb5', '\ufeb7', '\ufeb8', '\ufeb6'));
            charsMap.put("\u0635", new Shape('\ufeb9', '\ufebb', '\ufebc', '\ufeba'));
            charsMap.put("\u0636", new Shape('\ufebd', '\ufebf', '\ufec0', '\ufebe'));
            charsMap.put("\u0637", new Shape('\ufec1', '\ufec3', '\ufec4', '\ufec2'));
            charsMap.put("\u0638", new Shape('\ufec5', '\ufec7', '\ufec8', '\ufec6'));
            charsMap.put("\u0639", new Shape('\ufec9', '\ufecb', '\ufecc', '\ufeca'));
            charsMap.put("\u063a", new Shape('\ufecd', '\ufecf', '\ufed0', '\ufece'));
            charsMap.put("\u0640", new Shape('\u0640', '\u0000', '\u0000', '\u0000'));
            charsMap.put("\u0641", new Shape('\ufed1', '\ufed3', '\ufed4', '\ufed2'));
            charsMap.put("\u0642", new Shape('\ufed5', '\ufed7', '\ufed8', '\ufed6'));
            charsMap.put("\u0643", new Shape('\ufed9', '\ufedb', '\ufedc', '\ufeda'));
            charsMap.put("\u0644", new Shape('\ufedd', '\ufedf', '\ufee0', '\ufede'));
            charsMap.put("\u0645", new Shape('\ufee1', '\ufee3', '\ufee4', '\ufee2'));
            charsMap.put("\u0646", new Shape('\ufee5', '\ufee7', '\ufee8', '\ufee6'));
            charsMap.put("\u0647", new Shape('\ufee9', '\ufeeb', '\ufeec', '\ufeea'));
            charsMap.put("\u0648", new Shape('\ufeed', '\u0000', '\u0000', '\ufeee'));
            charsMap.put("\u0649", new Shape('\ufeef', '\ufbe8', '\ufbe9', '\ufef0'));
            charsMap.put("\u064a", new Shape('\ufef1', '\ufef3', '\ufef4', '\ufef2'));
            charsMap.put("\u0644\u0622", new Shape('\ufef5', '\u0000', '\u0000', '\ufef6'));
            charsMap.put("\u0644\u0623", new Shape('\ufef7', '\u0000', '\u0000', '\ufef8'));
            charsMap.put("\u0644\u0625", new Shape('\ufef9', '\u0000', '\u0000', '\ufefa'));
            charsMap.put("\u0644\u0627", new Shape('\ufefb', '\u0000', '\u0000', '\ufefc'));
        }

        private static final class Shape {
            char mIsolated;
            char mInitial;
            char mMedial;
            char mFinal;

            private Shape(char s, char i, char m, char f) {
                this.mIsolated = s;
                this.mInitial = i;
                this.mMedial = m;
                this.mFinal = f;
            }
        }
    }

    static final class Preferences
    extends Form
    implements CommandListener {
        private static final boolean D = Const.DEBUG;
        private static DeviceLighting BL = DeviceLighting.access$1000();
        private ChoiceGroup choices = new ChoiceGroup("Preferences", 2);
        private Gauge backLight = new Gauge("Backlight brightness", true, 100, 0);
        private Gauge backLightAS = new Gauge("Autoscroll backlight brightness", true, 100, 0);
        private ChoiceGroup colors = new ChoiceGroup("Colors", 1);
        private ChoiceGroup fonts = new ChoiceGroup("Font", 1);
        private Command oK = new Command("OK", 4, 1);
        private Command cancel = new Command("Cancel", 3, 1);
        private Vector fontVector = new Vector();
        private BookCanvas canvas;

        private Preferences(BookCanvas canvas) {
            super("Options");
            this.canvas = canvas;
            this.setCommandListener(this);
            this.choices.append("Wrap lines", null);
            if (Const.IS_MIDP2) {
                this.choices.append("Full Screen Mode", null);
            }
            this.choices.append("Rotate display", null);
            this.choices.append("Display status", null);
            this.choices.append("Show position as percent", null);
            this.choices.append("Hyphenate", null);
            this.choices.append("Full Justification", null);
            int i = 0;
            ++i;
            this.choices.setSelectedIndex(0, canvas.view.lineWrap);
            if (Const.IS_MIDP2) {
                this.choices.setSelectedIndex(1, canvas.fullscreen);
            }
            int n = ++i;
            this.choices.setSelectedIndex(n, canvas.view.rotated);
            int n2 = ++i;
            this.choices.setSelectedIndex(n2, canvas.displayStatus);
            int n3 = ++i;
            this.choices.setSelectedIndex(n3, canvas.positionAsPerc);
            int n4 = ++i;
            this.choices.setSelectedIndex(n4, canvas.view.hyphenate);
            this.choices.setSelectedIndex(++i, canvas.view.justify);
            this.backLight.setValue(DeviceLighting.access$2500(BL, false));
            this.backLightAS.setValue(DeviceLighting.access$2500(BL, true));
            String tmpWhite22 = "White";
            String tmpBlack = "Black";
            String tmpBlue = "Blue";
            this.addColors(tmpWhite22, tmpBlack);
            this.addColors(tmpWhite22, tmpBlue);
            this.addColors(tmpBlack, "Green");
            this.addColors(tmpBlue, tmpWhite22);
            this.colors.setSelectedIndex(canvas.view.colorScheme, true);
            this.addFont(64, 0, 8);
            this.addFont(64, 1, 8);
            this.addFont(32, 0, 8);
            this.addFont(32, 1, 8);
            this.addFont(64, 0, 0);
            this.addFont(64, 1, 0);
            this.addFont(32, 0, 0);
            this.addFont(32, 1, 0);
            this.addFont(64, 0, 16);
            this.addFont(64, 1, 16);
            this.addFont(32, 0, 16);
            this.addFont(32, 1, 16);
            int tmpWhite22 = 0;
            canvas = canvas.view.font;
            if (canvas.getSize() == 0) {
                tmpWhite22 = 4;
            } else if (canvas.getSize() == 16) {
                tmpWhite22 = 8;
            }
            if (canvas.getFace() == 32) {
                tmpWhite22 += 2;
            }
            if (canvas.getStyle() == 1) {
                ++tmpWhite22;
            }
            this.fonts.setSelectedIndex(tmpWhite22, true);
            this.append((Item)this.fonts);
            this.append((Item)this.choices);
            if (DeviceLighting.getLight()) {
                this.append((Item)this.backLight);
                this.append((Item)this.backLightAS);
            }
            this.append((Item)this.colors);
            this.addCommand(this.oK);
            this.addCommand(this.cancel);
        }

        private void addFont(int face, int style, int size2) {
            this.fontVector.addElement(Font.getFont((int)face, (int)style, (int)size2));
            String tmpFace = face == 64 ? "Proportional" : "Monospaced";
            String string = style = style == 0 ? "Normal" : "Bold";
            String size2 = size2 == 8 ? "Small" : (size2 == 0 ? "Medium" : "Large");
            this.fonts.append(size2 + " " + tmpFace + " " + style, null);
        }

        private void addColors(String bgName, String fgName) {
            this.colors.append(bgName + "/" + fgName, null);
        }

        public final void commandAction(Command cmd, Displayable disp3222) {
            disp3222 = cmd;
            cmd = this;
            if (disp3222 == cmd.cancel) {
                cmd.canvas.setBookScreen();
                return;
            }
            if (disp3222 == cmd.oK) {
                block5: {
                    int disp3222 = 0;
                    ++disp3222;
                    Page.access$1300(cmd.canvas.view, cmd.choices.isSelected(0));
                    if (Const.IS_MIDP2) {
                        cmd.canvas.setFullscreen(cmd.choices.isSelected(1));
                    }
                    int n = ++disp3222;
                    Page.access$1500(cmd.canvas.view, cmd.choices.isSelected(n));
                    int n2 = ++disp3222;
                    cmd.canvas.displayStatus = cmd.choices.isSelected(n2);
                    int n3 = ++disp3222;
                    cmd.canvas.positionAsPerc = cmd.choices.isSelected(n3);
                    int n4 = ++disp3222;
                    Page.access$1800(cmd.canvas.view, cmd.choices.isSelected(n4));
                    Page.access$1900(cmd.canvas.view, cmd.choices.isSelected(++disp3222));
                    DeviceLighting.access$1100(BL, false, cmd.backLight.getValue());
                    DeviceLighting.access$1100(BL, true, cmd.backLightAS.getValue());
                    Page.access$700(cmd.canvas.view, cmd.colors.getSelectedIndex());
                    Font disp3222 = (Font)cmd.fontVector.elementAt(cmd.fonts.getSelectedIndex());
                    try {
                        cmd.canvas.view.setFont(disp3222);
                    }
                    catch (Exception disp3222) {
                        if (!D) break block5;
                        Log.access$3500(disp3222);
                    }
                }
                cmd.canvas.setBookScreen();
            }
        }
    }

    private static final class BookList {
        private static final boolean D = Const.DEBUG;
        private final MicroStanza midlet;
        private String[] books;
        private Book activeBook;
        private int bookIdx = -1;

        private BookList(MicroStanza midlet) throws IOException {
            this.midlet = midlet;
            this.books = new String[]{midlet.getAppProperty("bookid")};
        }

        private String getBookName(int anIdx) {
            if (anIdx < 0) {
                throw new RuntimeException("Book index < 0");
            }
            if (anIdx >= this.books.length) {
                throw new RuntimeException("Too many books");
            }
            return this.books[anIdx];
        }

        private int getActivePosition() {
            int tmpResult;
            block4: {
                tmpResult = 0;
                if (this.bookIdx >= 0) {
                    try {
                        RecordStore tmpBookmarksRs = this.getBookmarksRS();
                        byte[] tmpBytes = tmpBookmarksRs.getRecord(1);
                        tmpBookmarksRs.closeRecordStore();
                        int n = this.bookIdx << 2;
                        tmpResult = 0;
                        for (int i = 0; i < 4; ++i) {
                            tmpResult |= (tmpBytes[i + n] & 0xFF) << (i << 3);
                        }
                    }
                    catch (Exception e) {
                        if (!D) break block4;
                        Log.access$3500(e);
                    }
                }
            }
            return tmpResult;
        }

        private RecordStore getBookmarksRS() throws RecordStoreFullException, RecordStoreNotFoundException, RecordStoreException {
            RecordStore tmpRS = null;
            tmpRS = RecordStore.openRecordStore((String)"bookmarks", (boolean)true);
            if (tmpRS.getNumRecords() == 0) {
                Object var4_2 = null;
                byte[] tmpBytes = new byte[this.books.length << 2];
                tmpRS.addRecord(tmpBytes, 0, tmpBytes.length);
                tmpBytes = new byte[]{};
                int n = this.books.length;
                for (int i = 0; i < n; ++i) {
                    tmpRS.addRecord(tmpBytes, 0, 0);
                }
            }
            return tmpRS;
        }

        private boolean addBookmark(String name, int position) {
            boolean tmpResult;
            block5: {
                if (name == null || this.bookIdx < 0) {
                    return false;
                }
                if ((name = name.trim()).length() == 0) {
                    return false;
                }
                tmpResult = true;
                try {
                    RecordStore tmpBookmarkRs = this.getBookmarksRS();
                    ByteArrayOutputStream tmpBaos = new ByteArrayOutputStream();
                    DataOutputStream tmpDos = new DataOutputStream(tmpBaos);
                    byte[] tmpBytes = tmpBookmarkRs.getRecord(2 + this.bookIdx);
                    if (tmpBytes != null && tmpBytes.length > 0) {
                        ((OutputStream)tmpDos).write(tmpBytes);
                    }
                    tmpDos.writeUTF(name);
                    tmpDos.writeInt(position);
                    tmpDos.flush();
                    tmpBytes = tmpBaos.toByteArray();
                    tmpBookmarkRs.setRecord(2 + this.bookIdx, tmpBytes, 0, tmpBytes.length);
                    tmpDos.close();
                }
                catch (Exception e) {
                    tmpResult = false;
                    if (!D) break block5;
                    Log.access$3500(e);
                }
            }
            return tmpResult;
        }

        private int fillBookmarkList(List list, Vector posVector) {
            int tmpResult;
            block7: {
                tmpResult = 0;
                try {
                    Object tmpBookmarkRs = null;
                    Object var5_6 = null;
                    byte[] tmpBytes = this.getBookmarksRS().getRecord(2 + this.bookIdx);
                    if (Const.DEBUG && D) {
                        Log.debug("Bookmarks byte array length: " + (tmpBytes == null ? -1 : tmpBytes.length));
                    }
                    if (tmpBytes != null && tmpBytes.length > 0) {
                        ByteArrayInputStream tmpBais = new ByteArrayInputStream(tmpBytes);
                        DataInputStream tmpDis = new DataInputStream(tmpBais);
                        try {
                            while (true) {
                                String tmpName = tmpDis.readUTF();
                                int tmpPos = tmpDis.readInt();
                                list.append(tmpName, null);
                                posVector.addElement(new Integer(tmpPos));
                                ++tmpResult;
                            }
                        }
                        catch (EOFException eOFException) {
                            tmpDis.close();
                        }
                    }
                }
                catch (Exception e) {
                    if (!D) break block7;
                    Log.access$3500(e);
                }
            }
            return tmpResult;
        }

        static /* synthetic */ void access$500(BookList x02, int x1) {
            block3: {
                if (x02.bookIdx >= 0) {
                    try {
                        RecordStore recordStore = x02.getBookmarksRS();
                        byte[] byArray = recordStore.getRecord(1);
                        int x02 = x02.bookIdx << 2;
                        byArray[x02] = (byte)x1;
                        byArray[x02 + 1] = (byte)(x1 >> 8);
                        byArray[x02 + 2] = (byte)(x1 >> 16);
                        byArray[x02 + 3] = x1 >> 24;
                        recordStore.setRecord(1, byArray, 0, byArray.length);
                        recordStore.closeRecordStore();
                        return;
                    }
                    catch (Exception exception) {
                        if (!D) break block3;
                        Log.access$3500(exception);
                    }
                }
            }
        }

        static /* synthetic */ void access$800(BookList x0, int x1) {
            if (x1 >= x0.books.length) {
                x0.bookIdx = -1;
                try {
                    RecordStore.deleteRecordStore((String)"bookmarks");
                    return;
                }
                catch (Exception exception) {
                    return;
                }
            }
            x0.bookIdx = x1;
        }

        static /* synthetic */ int access$4500(BookList x0) {
            return x0.books.length;
        }

        static /* synthetic */ int access$5100(BookList x0, List x1, Vector x2) {
            return x0.fillBookmarkList(x1, x2);
        }

        static /* synthetic */ boolean access$5700(BookList x0, String x1, int x2) {
            return x0.addBookmark(x1, x2);
        }

        static /* synthetic */ void access$5800(BookList x0, int x1, List x22, Vector x3) {
            if (x1 < 0 || x1 >= x22.size()) {
                return;
            }
            x22.delete(x1);
            ((Vector)x3).removeElementAt(x1);
            try {
                x22 = x0.getBookmarksRS();
                byte[] byArray = x22.getRecord(2 + x0.bookIdx);
                x3 = byArray;
                if (byArray != null && ((Object)x3).length > 0) {
                    x3 = new ByteArrayInputStream((byte[])x3);
                    x3 = new DataInputStream((InputStream)x3);
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                    try {
                        int n = 0;
                        while (true) {
                            if (n != x1) {
                                dataOutputStream.writeUTF(((DataInputStream)x3).readUTF());
                                dataOutputStream.writeInt(((DataInputStream)x3).readInt());
                            } else if (D) {
                                Log.debug("Deleting bookmark at index " + n);
                            }
                            ++n;
                        }
                    }
                    catch (EOFException eOFException) {
                        ((FilterInputStream)x3).close();
                        dataOutputStream.flush();
                        x3 = byteArrayOutputStream.toByteArray();
                        x22.setRecord(2 + x0.bookIdx, (byte[])x3, 0, ((Object)x3).length);
                        dataOutputStream.close();
                    }
                }
                return;
            }
            catch (Exception x22) {
                if (D) {
                    Log.access$3500(x22);
                }
                return;
            }
        }

        static /* synthetic */ Book access$5900(BookList x0, int x1) {
            if (x1 >= 0 && (x0.bookIdx != x1 || x0.activeBook == null)) {
                x0.bookIdx = x1;
                x0.activeBook = new Book(x0.getBookName(x1), x0.midlet);
                x0.activeBook.setPosition(x0.getActivePosition());
            }
            return x0.activeBook;
        }
    }

    static final class SplashScreen
    extends Canvas {
        private static final boolean D = Const.DEBUG;

        private SplashScreen() throws Exception {
        }

        public final void paint(Graphics g2) {
            Graphics graphics = g2;
            g2 = this;
            try {
                int n = g2.getWidth();
                int g2 = g2.getHeight();
                Image image = Image.createImage((String)"/stanza/micro/splash.png");
                graphics.setColor(0xFFFFFF);
                graphics.fillRect(0, 0, n, g2);
                graphics.drawImage(image, (n - image.getWidth()) / 2, (g2 - image.getHeight()) / 2, 20);
                return;
            }
            catch (Exception exception) {
                if (D) {
                    Log.access$3500(exception);
                }
                return;
            }
        }

        /* synthetic */ SplashScreen(MicroStanza x0) throws Exception {
            this();
        }
    }

    static final class BookCanvas
    extends Canvas
    implements CommandListener {
        private static final boolean D = Const.DEBUG;
        private static int scrollDelay = 1000;
        private List list;
        private final MicroStanza midlet;
        private Page view;
        private String message = null;
        private Font messageFont;
        private Command bookList;
        private final Command info;
        private final Command options;
        private final Command position;
        private final Command addBookmark;
        private final Command openBookmark;
        private final Command exit;
        private final Command chapters;
        private final Command remove;
        private final Command oK;
        private final Command cancel;
        private Gauge gauge;
        private TextField textfield;
        private Form form;
        private ScrollThread scrollThread = new ScrollThread();
        private Vector listVector;
        private byte screenIdx;
        private final Display display;
        private boolean fullscreen;
        private boolean displayStatus;
        private boolean positionAsPerc = true;
        private Integer dragX;
        private Integer dragY;

        private BookCanvas(MicroStanza midlet) throws Exception {
            this.midlet = midlet;
            this.display = Display.getDisplay((MIDlet)midlet);
            this.view = new Page(this.getWidth(), this.getHeight());
            this.messageFont = Font.getFont((int)0, (int)1, (int)8);
            this.chapters = new Command("Chapters", 1, 1);
            this.position = new Command("Contents", 1, 2);
            this.options = new Command("Preferences", 1, 3);
            this.info = new Command("Book Info", 1, 4);
            this.addBookmark = new Command("Add Bookmark", 1, 5);
            this.openBookmark = new Command("Show Bookmarks", 1, 6);
            this.exit = new Command("Quit", 1, 10);
            this.remove = new Command("Remove", 1, 2);
            this.oK = new Command("OK", 4, 1);
            this.cancel = new Command("Cancel", 3, 1);
            this.addCommand(this.position);
            this.addCommand(this.info);
            this.addCommand(this.options);
            this.addCommand(this.addBookmark);
            this.addCommand(this.openBookmark);
            this.addCommand(this.exit);
            if (BookList.access$4500(midlet.bookList) > 1) {
                this.bookList = new Command("Books", 1, 4);
                this.addCommand(this.bookList);
            }
            this.setCommandListener(this);
            this.scrollThread.start();
        }

        private Displayable createBookList(long time) {
            Object var3_2 = null;
            this.list = new List("Select Book", 3);
            int n = BookList.access$4500(this.midlet.bookList);
            for (int i = 0; i < n; ++i) {
                this.list.append(this.midlet.bookList.getBookName(i), null);
            }
            int idx = this.midlet.bookList.bookIdx;
            this.list.setSelectedIndex(idx > -1 ? idx : 0, true);
            this.list.setCommandListener((CommandListener)this);
            this.screenIdx = 1;
            BookCanvas.waitForIntroEnd(time);
            this.display.setCurrent((Displayable)this.list);
            return this.list;
        }

        private static void waitForIntroEnd(long time) {
            block3: {
                if (time > 0L && (time = time + 1000L - System.currentTimeMillis()) > 0L) {
                    try {
                        Thread.sleep(time);
                        return;
                    }
                    catch (Throwable e) {
                        if (!D) break block3;
                        Log.access$3500(e);
                    }
                }
            }
        }

        private void releaseForm() {
            this.form = null;
            this.textfield = null;
            this.gauge = null;
            this.setBookScreen();
        }

        public final void paint(Graphics g) {
            Graphics graphics = g;
            g = this;
            g.view.draw(graphics, 0, 0);
            if (g.message != null) {
                graphics.setFont(g.messageFont);
                int n = g.messageFont.stringWidth(g.message);
                int n2 = g.messageFont.getHeight();
                graphics.setColor(0xFFFFFF);
                graphics.fillRect(2, 2, n + 3, n2 + 3);
                graphics.setColor(0);
                graphics.drawString(g.message, 4, 4, 20);
                graphics.drawRect(2, 2, n + 3, n2 + 3);
            }
        }

        public final void keyPressed(int key) {
            this.key(key);
        }

        public final void keyRepeated(int key) {
            this.key(key);
        }

        private synchronized void key(int key22) {
            int key22;
            int action = this.getGameAction(key22);
            BookCanvas bookCanvas = null;
            if (!this.scrollThread.canRun()) {
                bookCanvas = this;
                switch (action) {
                    case 1: {
                        bookCanvas.prevPage();
                        return;
                    }
                    case 6: {
                        bookCanvas.nextPage();
                        return;
                    }
                    case 5: {
                        Object key22 = null;
                        bookCanvas.nextLine(1);
                        return;
                    }
                    case 2: {
                        Object key22 = null;
                        bookCanvas.previousLine(1);
                        return;
                    }
                }
                switch (key22) {
                    case -13: 
                    case 49: 
                    case 52: 
                    case 55: {
                        bookCanvas.prevPage();
                        return;
                    }
                    case 50: {
                        Object key22 = null;
                        bookCanvas.previousLine(1);
                        return;
                    }
                    case -14: 
                    case 48: 
                    case 51: 
                    case 54: 
                    case 57: {
                        bookCanvas.nextPage();
                        return;
                    }
                    case 56: {
                        Object key22 = null;
                        bookCanvas.nextLine(1);
                        return;
                    }
                    case 53: {
                        Object key22 = null;
                        bookCanvas.scrollThread.setRun(true);
                        return;
                    }
                    case 35: {
                        Page.access$1500(bookCanvas.view, !bookCanvas.view.rotated);
                        bookCanvas.repaint();
                        return;
                    }
                    case 42: {
                        Object key22 = null;
                        bookCanvas.setFullscreen(!bookCanvas.fullscreen);
                        bookCanvas.view.resetPage();
                        bookCanvas.repaint();
                    }
                }
                return;
            }
            bookCanvas = this;
            if (action == 1 || action == 2 || key22 == 52) {
                BookCanvas.addScrollDelay(50);
            } else if (action == 6 || action == 5 || key22 == 54) {
                BookCanvas.addScrollDelay(-50);
            }
            if (key22 == 53) {
                Object key22 = null;
                bookCanvas.messageOn("Stopping");
                bookCanvas.scrollThread.setRun(false);
                return;
            }
            bookCanvas.messageOn("Delay: " + BookCanvas.getScrollDelay());
        }

        public final void pointerDragged(int x, int y) {
            if (this.dragX == null) {
                this.dragX = new Integer(x);
                this.dragY = new Integer(y);
            }
            int offsetX = x - this.dragX;
            int offsetY = y - this.dragY;
            if (this.view.rotated) {
                if (offsetX > 0) {
                    this.previousLine(offsetX);
                } else if (offsetX < 0) {
                    this.nextLine(-offsetX);
                }
            } else if (offsetY > 0) {
                this.previousLine(offsetY);
            } else if (offsetY < 0) {
                this.nextLine(-offsetY);
            }
            this.dragX = new Integer(x);
            this.dragY = new Integer(y);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void pointerReleased(int x2, int y2) {
            if (this.dragX == null) {
                x2 = (y2 << 2) / this.getHeight();
                BookCanvas y2 = this;
                synchronized (y2) {
                    switch (x2) {
                        case 0: {
                            this.prevPage();
                            break;
                        }
                        case 1: {
                            Object x2 = null;
                            this.previousLine(1);
                            break;
                        }
                        case 2: {
                            Object x2 = null;
                            this.nextLine(1);
                            break;
                        }
                        case 3: {
                            this.nextPage();
                        }
                    }
                }
            }
            this.dragX = null;
            this.dragY = null;
        }

        public final void pointerPressed(int x, int y) {
        }

        /*
         * Unable to fully structure code
         */
        public final void commandAction(Command cmd, Displayable disp) {
            disp = cmd;
            cmd = this;
            switch (cmd.screenIdx) {
                case 0: {
                    if (disp == cmd.chapters) {
                        disp = cmd;
                        cmd.list = new List("Chapters", 3);
                        disp.listVector = new Vector<E>();
                        Book.access$4800(Page.access$4700(disp.view), disp.list, disp.listVector);
                        disp.list.setCommandListener((CommandListener)disp);
                        disp.screenIdx = (byte)8;
                        disp.display.setCurrent((Displayable)disp.list);
                        return;
                    }
                    if (disp == cmd.exit) {
                        cmd.midlet.destroyApp(false);
                        return;
                    }
                    if (disp == cmd.position) {
                        disp = cmd;
                        cmd.form = new Form("Position");
                        if (disp.positionAsPerc) {
                            var3_6 = Page.access$4900(disp.view);
                            if (var3_6 < 0 || var3_6 > 100) {
                                throw new RuntimeException("gauge out of range");
                            }
                            disp.gauge = new Gauge("Position in Book", true, 100, 0);
                            disp.gauge.setValue(var3_6);
                            disp.form.append((Item)disp.gauge);
                        } else {
                            var3_7 = Integer.toString(Page.access$5000(disp.view));
                            cmd = Integer.toString(Page.access$4700((Page)disp.view).size).length();
                            disp.textfield = new TextField("Position in Book", var3_7, cmd, 2);
                            disp.form.append((Item)disp.textfield);
                        }
                        disp.form.addCommand(disp.oK);
                        disp.form.addCommand(disp.cancel);
                        disp.form.setCommandListener((CommandListener)disp);
                        disp.display.setCurrent((Displayable)disp.form);
                        disp.screenIdx = (byte)4;
                        return;
                    }
                    if (disp == cmd.info) {
                        v0 = cmd;
                        cmd = Page.access$4700((Page)cmd.view).title;
                        var3_8 = Page.access$4700((Page)cmd.view).id;
                        disp = v0;
                        v0.form = new Form("Info");
                        if (var3_8 != null) {
                            var3_8.length();
                        }
                        if (cmd == null || cmd.length() == 0) {
                            cmd = "<Empty>";
                        }
                        disp.form.append((Item)new StringItem("Title", (String)cmd));
                        disp.form.append("\n");
                        disp.form.append((Item)new StringItem("Help", "Commands:\n2 Previous Line\n4 Previous Page\n5 Start/Stop Scrolling\n6 Next Page\n8 Next Line\n* Enter/Leave Full Screen\n# Rotate Screen\n"));
                        disp.form.append((Item)new StringItem("", ""));
                        disp.form.addCommand(disp.oK);
                        disp.form.setCommandListener((CommandListener)disp);
                        disp.screenIdx = (byte)7;
                        disp.display.setCurrent((Displayable)disp.form);
                        return;
                    }
                    if (disp == cmd.options) {
                        cmd.display.setCurrent((Displayable)new Preferences((BookCanvas)cmd));
                        return;
                    }
                    if (disp == cmd.addBookmark) {
                        disp = cmd;
                        cmd.form = new Form("Add Bookmark");
                        disp.textfield = new TextField("Name", null, 10, 0);
                        disp.form.append((Item)disp.textfield);
                        disp.form.addCommand(disp.oK);
                        disp.form.addCommand(disp.cancel);
                        disp.form.setCommandListener((CommandListener)disp);
                        disp.display.setCurrent((Displayable)disp.form);
                        disp.screenIdx = (byte)10;
                        return;
                    }
                    if (disp == cmd.openBookmark) {
                        disp = cmd;
                        cmd.list = new List("Go to bookmark", 3);
                        disp.listVector = new Vector<E>();
                        if (BookList.access$5100(disp.midlet.bookList, disp.list, disp.listVector) > 0) {
                            disp.list.addCommand(disp.oK);
                            disp.list.addCommand(disp.remove);
                        }
                        disp.list.addCommand(disp.cancel);
                        disp.list.setCommandListener((CommandListener)disp);
                        disp.screenIdx = (byte)11;
                        disp.display.setCurrent((Displayable)disp.list);
                        return;
                    }
                    if (disp == cmd.bookList) {
                        BookList.access$500(cmd.midlet.bookList, Page.access$5000(cmd.view));
                        super.createBookList(0L);
                    }
                    return;
                }
                case 1: {
                    if (cmd.list != null) {
                        super.setBook(cmd.list.getSelectedIndex(), -1L);
                        cmd.list = null;
                    }
                    return;
                }
                case 4: {
                    if (cmd.form == null || disp != cmd.oK) ** GOTO lbl113
                    if (!cmd.positionAsPerc) ** GOTO lbl106
                    Page.access$5500(cmd.view, cmd.gauge.getValue());
                    ** GOTO lbl113
lbl106:
                    // 1 sources

                    try {
                        disp = Integer.parseInt(cmd.textfield.getString());
                        Page.access$5600(cmd.view, disp);
                    }
                    catch (NumberFormatException v1) {
                        if (!Const.DEBUG || !BookCanvas.D || !BookCanvas.D) ** GOTO lbl113
                        Log.access$3300("commandActPosition: Can't convert '" + cmd.textfield.getString() + "' to integer.");
                    }
lbl113:
                    // 5 sources

                    super.releaseForm();
                    return;
                }
                case 10: {
                    if (cmd.form != null && disp == cmd.oK) {
                        BookList.access$5700(cmd.midlet.bookList, cmd.textfield.getString(), Page.access$5000(cmd.view));
                    }
                    super.releaseForm();
                    return;
                }
                case 11: {
                    if (cmd.list != null && cmd.listVector != null) {
                        if (disp == cmd.remove) {
                            BookList.access$5800(cmd.midlet.bookList, cmd.list.getSelectedIndex(), cmd.list, cmd.listVector);
                            if (cmd.listVector.size() > 0) {
                                cmd.list.setSelectedIndex(0, true);
                                return;
                            }
                            cmd.list.removeCommand(cmd.remove);
                            cmd.list.removeCommand(cmd.oK);
                            return;
                        }
                        if (disp == cmd.oK && (disp = cmd.list.getSelectedIndex()) >= 0) {
                            var3_9 = (Integer)cmd.listVector.elementAt(disp);
                            Page.access$5600(cmd.view, var3_9);
                        }
                        super.setBookScreen();
                        cmd.list = null;
                        cmd.listVector = null;
                    }
                    return;
                }
                case 6: 
                case 7: {
                    super.releaseForm();
                    return;
                }
                case 8: {
                    if (cmd.list == null || cmd.listVector == null) break;
                    disp = (Integer)cmd.listVector.elementAt(cmd.list.getSelectedIndex());
                    Page.access$5600(cmd.view, disp.intValue());
                    super.setBookScreen();
                    cmd.list = null;
                    cmd.listVector = null;
                }
            }
        }

        private void setBook(int idx2, long time) {
            Book idx2 = BookList.access$5900(this.midlet.bookList, idx2);
            this.removeCommand(this.chapters);
            Page.access$6000(this.view, idx2);
            BookCanvas.waitForIntroEnd(time);
            this.setBookScreen();
        }

        private void setBookScreen() {
            this.display.setCurrent((Displayable)this);
            this.screenIdx = 0;
        }

        private void nextLine(int count) {
            try {
                Object var2_2 = null;
                this.messageOn("Please wait");
                for (int i = 0; i < count; ++i) {
                    this.view.nextLine();
                }
                this.messageOff();
                return;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
        }

        private void nextPage() {
            try {
                this.messageOn("Please wait");
                Page.access$6300(this.view);
                this.messageOff();
                return;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
        }

        private void previousLine(int count) {
            try {
                Object var2_2 = null;
                this.messageOn("Please wait");
                for (int i = 0; i < count; ++i) {
                    this.view.lastLine();
                }
                this.messageOff();
                return;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
        }

        private void prevPage() {
            try {
                this.messageOn("Please wait");
                Page.access$6500(this.view);
                this.messageOff();
                return;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
        }

        private synchronized void messageOn(String msg) {
            if (this.displayStatus) {
                this.message = msg;
                this.repaint();
                this.serviceRepaints();
            }
        }

        private synchronized void messageOff() {
            this.message = null;
            this.repaint();
        }

        protected final void hideNotify() {
            this.scrollThread.setRun(false);
        }

        private static synchronized void setScrollDelay(int delay) {
            if (delay < 50) {
                delay = 50;
            }
            scrollDelay = delay;
        }

        private static synchronized void addScrollDelay(int delay) {
            BookCanvas.setScrollDelay(BookCanvas.getScrollDelay() + delay);
        }

        private static synchronized int getScrollDelay() {
            return scrollDelay;
        }

        private void setFullscreen(boolean fullscreen) {
            this.fullscreen = fullscreen;
            if (Const.IS_MIDP2) {
                try {
                    this.setFullScreenMode(fullscreen);
                    this.view.setDimension(this.getWidth(), this.getHeight());
                    return;
                }
                catch (Throwable t) {
                    if (D) {
                        Log.access$3500(t);
                    }
                    return;
                }
            }
            this.view.setDimension(this.getWidth(), this.getHeight());
        }

        static /* synthetic */ void access$300(BookCanvas x0, long x1) {
            long l = x1;
            if (BookList.access$4500(x0.midlet.bookList) == 1) {
                BookList.access$800(x0.midlet.bookList, 0);
            }
            if ((x1 = x0.midlet.bookList.bookIdx) > -1 && BookList.access$4500(x0.midlet.bookList) > x1) {
                x0.setBook(x0.midlet.bookList.bookIdx, l);
            } else {
                x0.createBookList(l);
            }
            DeviceLighting.access$1000();
        }

        static /* synthetic */ int access$400(BookCanvas x0) {
            return Page.access$5000(x0.view);
        }

        static /* synthetic */ void access$6900(Throwable x0) {
            Log.access$3500(x0);
        }

        private final class ScrollThread
        extends Thread {
            private boolean run = false;

            private ScrollThread() {
            }

            public final void run() {
                try {
                    while (true) {
                        if (this.canRun()) {
                            if (!BookCanvas.this.view.nextLine()) {
                                this.setRun(false);
                            }
                            BookCanvas.this.messageOff();
                        }
                        try {
                            Thread.sleep(BookCanvas.getScrollDelay());
                        }
                        catch (Throwable e) {
                            if (!D) continue;
                            BookCanvas.access$6900(e);
                        }
                    }
                }
                catch (Exception exception) {
                    return;
                }
            }

            final synchronized void setRun(boolean run) {
                this.run = run;
                if (run) {
                    DeviceLighting.access$1000();
                    return;
                }
                DeviceLighting.access$1000();
                BookCanvas.this.messageOff();
            }

            final synchronized boolean canRun() {
                return this.run;
            }
        }
    }

    static final class Log {
        Log() {
        }

        private static synchronized void debug(String what) {
            if (Const.DEBUG) {
                System.out.println(what);
            }
        }

        static /* synthetic */ void access$3500(Object x0) {
            System.err.print("Error: ");
            if (x0 instanceof Throwable) {
                ((Throwable)x0).printStackTrace();
                return;
            }
            System.err.println(x0.toString());
        }
    }

    static final class Const {
        static final boolean IS_MIDP2 = "MIDP-2.0".equals(System.getProperty("microedition.profiles"));
        static final boolean DEBUG = "MicroEmulator".equals(System.getProperty("microedition.platform"));

        Const() {
        }
    }

    static final class Book {
        private static final boolean D = Const.DEBUG;
        private static DocumentBuffer nextBuff;
        private static BufferThread bfThread;
        String id;
        String title;
        int size;
        private int partSize;
        private boolean rightToLeft;
        private DocumentBuffer buffer;
        private int index;

        private Book(String id, MicroStanza midlet) {
            this.id = id;
            this.size = Integer.parseInt(midlet.getAppProperty(id + "-size"));
            this.partSize = Integer.parseInt(midlet.getAppProperty(id + "-segsize"));
            this.title = midlet.getAppProperty(id + "-title");
            this.rightToLeft = "true".equals(midlet.getAppProperty(id + "-bidi"));
        }

        private synchronized void fillBuffer(int part2) throws Exception {
            if (part2 * this.partSize > this.size - 1) {
                throw new EOFException();
            }
            while (Book.getBufferThread() != null) {
                try {
                    Thread.sleep(200L);
                }
                catch (Throwable e) {
                    if (!D) continue;
                    Log.access$3500(e);
                }
            }
            DocumentBuffer tmpNext = Book.nextBuffer();
            if (tmpNext != null && part2 == tmpNext.partNo) {
                this.buffer = tmpNext;
                Book.setNextBuffer(null);
            } else {
                this.buffer = new DocumentBuffer(part2, this.partSize, this.id);
                DocumentBuffer.access$3700(this.buffer, this.rightToLeft);
            }
            BufferThread part2 = new BufferThread(part2 + 1, this.partSize, this.id, this.rightToLeft);
            part2.setPriority(2);
            part2.start();
        }

        private void loadBuffer(int part) throws Exception {
            if (this.buffer != null && part == this.buffer.partNo) {
                return;
            }
            if (part < 0) {
                throw new RuntimeException("Negative buffer");
            }
            int tmpBuffMax = this.size / this.partSize;
            if (this.size % this.partSize == 0) {
                --tmpBuffMax;
            }
            if (part > tmpBuffMax) {
                throw new RuntimeException("Buffer too large");
            }
            this.fillBuffer(part);
        }

        private synchronized int getPosition() {
            if (this.buffer == null) {
                return 0;
            }
            return this.buffer.partNo * this.partSize + this.index;
        }

        /*
         * WARNING - void declaration
         */
        private synchronized int setPosition(int pos) {
            void var1_1;
            if (pos < 0) {
                pos = 0;
            } else if (pos >= this.size) {
                pos = this.size - 1;
            }
            try {
                this.loadBuffer(pos / this.partSize);
                this.index = pos % this.partSize;
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
            return (int)var1_1;
        }

        private static synchronized DocumentBuffer nextBuffer() {
            return nextBuff;
        }

        private static synchronized void setNextBuffer(DocumentBuffer nextBuff) {
            Book.nextBuff = nextBuff;
        }

        private static synchronized BufferThread getBufferThread() {
            return bfThread;
        }

        private static synchronized void setBufferThread(BufferThread bfThread) {
            Book.bfThread = bfThread;
        }

        static /* synthetic */ void access$4800(Book x0, List x1, Vector x2) {
            Book book = x0;
            x0 = "chapters";
            Book book2 = book;
            x0 = book.getClass().getResourceAsStream("/books/" + book2.id + "/" + (String)x0);
            if (x0 != null) {
                x0 = new DataInputStream((InputStream)x0);
                try {
                    int n = ((DataInputStream)x0).readInt();
                    if (D) {
                        Log.debug(n + " chapters available");
                    }
                    for (int i = 0; i < n; ++i) {
                        x1.append(((DataInputStream)x0).readUTF(), null);
                        x2.addElement(new Integer(((DataInputStream)x0).readInt()));
                    }
                    ((FilterInputStream)x0).close();
                    return;
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException.getMessage());
                }
            }
        }

        static /* synthetic */ char access$8900(Book x0, int x1) throws Exception {
            Book book = x0;
            if (x0.getPosition() >= book.size || book.getPosition() <= -1) {
                throw new EOFException();
            }
            if (book.index <= -1) {
                Book book2 = book;
                if (book2.buffer == null || book2.buffer.partNo <= 0) {
                    throw new Exception("Start of buffer");
                }
                book2.loadBuffer(book2.buffer.partNo - 1);
                book.index = book.buffer.bufferLength - 1;
            } else if (book.index >= book.buffer.bufferLength) {
                Book book3 = book;
                if (book3.buffer == null || (book3.buffer.partNo + 1) * book3.partSize >= book3.size) {
                    throw new Exception("End of buffer");
                }
                book3.loadBuffer(book3.buffer.partNo + 1);
                book.index = 0;
            }
            char c = book.buffer.getBuffer()[book.index];
            x0.index += x1;
            return c;
        }

        static {
            bfThread = null;
        }

        static final class BufferThread
        extends Thread {
            private DocumentBuffer holder;
            private boolean rightToLeft;

            private BufferThread(int part, int size, String id, boolean rL) {
                this.setHolder(new DocumentBuffer(part, size, id));
                Book.setBufferThread(this);
                this.rightToLeft = rL;
            }

            public final void run() {
                BufferThread bufferThread = this;
                try {
                    DocumentBuffer.access$3700(bufferThread.getHolder(), bufferThread.rightToLeft);
                }
                catch (IOException iOException) {}
                Book.setNextBuffer(bufferThread.getHolder());
                Book.setBufferThread(null);
            }

            private synchronized void setHolder(DocumentBuffer holder) {
                this.holder = holder;
            }

            private synchronized DocumentBuffer getHolder() {
                return this.holder;
            }
        }

        static final class DocumentBuffer {
            private char[] buffer;
            volatile int bufferLength;
            volatile int partNo;
            private String path;

            private DocumentBuffer(int part, int size, String iD) {
                this.partNo = part;
                this.bufferLength = size;
                this.path = "/books/" + iD + "/" + "seg" + this.partNo;
            }

            final synchronized char[] getBuffer() {
                return this.buffer;
            }

            private synchronized void setBuffer(char[] buff) {
                this.buffer = buff;
            }

            static /* synthetic */ void access$3700(DocumentBuffer x0, boolean x1) throws IOException {
                Closeable closeable = x0.getClass().getResourceAsStream(x0.path);
                if (closeable != null) {
                    int n;
                    closeable = new InputStreamReader((InputStream)closeable, "UTF-8");
                    char[] cArray = new char[x0.bufferLength];
                    x0.bufferLength = n = ((Reader)closeable).read(cArray);
                    while (n > 0 && x0.bufferLength < cArray.length) {
                        n = ((Reader)closeable).read(cArray, x0.bufferLength, cArray.length - x0.bufferLength);
                        if (n <= 0) continue;
                        x0.bufferLength += n;
                    }
                    if (x1) {
                        cArray = RTLText.access$4000(new String(cArray, 0, x0.bufferLength)).toCharArray();
                        x0.bufferLength = cArray.length;
                    }
                    x0.setBuffer(cArray);
                    ((Reader)closeable).close();
                }
            }
        }
    }

    static final class DeviceLighting {
        private static DeviceLighting instance;
        private int backLight = 30;
        private int autoLight = 30;

        private DeviceLighting() {
        }

        private static boolean getLight() {
            try {
                Class.forName("com.siemens.mp.game.Light");
                return true;
            }
            catch (Throwable throwable) {
                try {
                    Class.forName("com.nokia.mid.ui.DeviceControl");
                    return true;
                }
                catch (Throwable throwable2) {
                    return false;
                }
            }
        }

        static /* synthetic */ DeviceLighting access$1000() {
            if (instance == null) {
                instance = new DeviceLighting();
            }
            return instance;
        }

        static /* synthetic */ void access$1100(DeviceLighting x0, boolean x1, int x2) {
            if (x1) {
                x0.autoLight = x2;
                return;
            }
            x0.backLight = x2;
        }

        static /* synthetic */ int access$2500(DeviceLighting x0, boolean x1) {
            if (x1) {
                return x0.autoLight;
            }
            return x0.backLight;
        }
    }
}

